﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public partial class Administration : BaseComponent
    {
        protected class ClassEditCompetencesPanel : ClassEditBasePanel
        {
            public ClassEditCompetencesPanel(Administration Component) : base(Component) { }

            private List<BL.BO.View.CompetencePart_Class> _listCompetencePart_Class = null;

            protected List<BL.BO.View.CompetencePart_Class> CompetencePart_ClassList
            {
                get
                {
                    if (_listCompetencePart_Class == null)
                    {
                        BL.BO.CompetencePart_Class.Search _search = new BL.BO.CompetencePart_Class.Search();
                        _search.ClassID = Class.ID;
                        _listCompetencePart_Class = Component.BLELearning.CompetencePart.Class.View.Restore(_search);
                    }
                    return _listCompetencePart_Class;
                }
            }
            
            public override void Load()
            {
                base.Load();
                if (Class != null && Component.Instructor != null)
                {
                    Component.XML.Element.Start("CompetencePart_ClassList");
                    foreach (BL.BO.View.CompetencePart_Class _loopCompetencePart_Class in CompetencePart_ClassList)
                    {
                        Component.XML.Element.Start("CompetencePart_Class");
                        Component.XML.Element.Attribute("ClassID", _loopCompetencePart_Class.ClassID);
                        Component.XML.Element.Attribute("CompetenceID", _loopCompetencePart_Class.CompetenceID);
                        Component.XML.Element.Attribute("CompetenceName", _loopCompetencePart_Class.CompetenceName);
                        Component.XML.Element.Attribute("CompetencePartID", _loopCompetencePart_Class.CompetencePartID);
                        Component.XML.Element.Attribute("CompetencePartName", _loopCompetencePart_Class.CompetencePartName);
                        Component.XML.Element.Attribute("ID", _loopCompetencePart_Class.ID);
                        Component.XML.Element.Attribute("IsAvailable", _loopCompetencePart_Class.IsAvailable);
                        Component.XML.Element.End();
                    }
                    Component.XML.Element.End();
                }
            }

            public override bool Save()
            {
                Component.MethodResult.SetSuccess = base.Save();

                if (Component.MethodResult.Success)
                {
                    switch (EditMode)
                    {
                        case EditModeType.EditOrInsert:
                            try
                            {
                                foreach (BL.BO.View.CompetencePart_Class _loopCompetencePart_Class in CompetencePart_ClassList)
                                {
                                    _loopCompetencePart_Class.IsAvailable = Component.Environment.GetRequestParamBool("CompetencePart_Class_IsAvailable_" + _loopCompetencePart_Class.ID);
                                    Component.MethodResult.Add(Component.BLELearning.CompetencePart.Class.Save(_loopCompetencePart_Class));
                                }
                            }
                            catch (Exception _exception)
                            {
                                Component.MethodResult.Add(_exception);
                            }
                            break;
                        case EditModeType.Remove:
                            break;
                    }
                }
                return Component.MethodResult.Success;
            }
        }
    }
}
